#include <reg52.h>       /* special function register declarations   */
#include <absacc.h>      /* for the intended 8051 derivative         */
#include <stdio.h>       /* prototype declarations for I/O functions */

                             /*     dp  g   f   e   d   c   b   a   */
unsigned char tab[]={ 0x3f,  /* 0:  0   0   1   1   1   1   1   1   */
                      0x06,  /* 1:  0   0   0   0   0   1   1   0   */
                      0x5b,  /* 2:  0   1   0   1   1   0   1   1   */
                      0x4f,  /* 3:  0   1   0   0   1   1   1   1   */
                      0x66,  /* 4:  0   1   1   0   0   1   1   0   */
                      0x6d,  /* 5:  0   1   1   0   1   1   0   1   */
                      0x7d,  /* 6:  0   1   1   1   1   1   0   1   */
                      0x27,  /* 7:  0   0   1   0   0   1   1   1   */
                      0x7f,  /* 8:  0   1   1   1   1   1   1   1   */
                      0x6f,  /* 9:  0   1   1   0   1   1   1   1   */
                      0x77,  /* a:  0   1   1   1   0   1   1   1   */
                      0x7c,  /* b:  0   1   1   1   1   1   0   0   */
                      0x39,  /* c:  0   0   1   1   1   0   0   1   */
                      0x5e,  /* d:  0   1   0   1   1   1   1   0   */
                      0x79,  /* e:  0   1   1   1   1   0   0   1   */
                      0x71,  /* f:  0   1   1   1   0   0   0   1   */
                      0x00,  /*  :  0   0   0   0   0   0   0   0   */
                      0x40   /* -:  0   1   0   0   0   0   0   0   */
                    };

unsigned char ScanPos = 0;
unsigned char dis[6];
unsigned char Dig[2] = {
  0x01, 0x02
};



unsigned AddrH = 0x00;
unsigned AddrL = 0x00;

unsigned char xdata RxBuf[64];
unsigned char xdata Buffer[64];

unsigned char x, y, z;

unsigned char KEY;

unsigned char RdData;

unsigned char timer=0;

sbit ADCS = P1^4;
sbit ADCK = P1^7;
sbit ADDO = P1^5;
sbit ADDI = P1^6;

sbit WP = P1^4;
sbit SCL = P1^3;
sbit SDA = P1^2;

void EESclPulse(void);
char EEStartRead(void);
char EEStartWrite(unsigned int Addr);
void EEStop(void);
void EEWritePage(unsigned char * pBuf);
void EEReadPage(unsigned char xdata * pBuf);
  
void main (void)  
{
  TMOD |= 0x01;   
  TH0 = 0xf7;
  TR0 = 1; 
  
  IE |= 0x82;
  
  for(x = 0; x < 64; x ++)
  {
    Buffer[x] = x;
  }
  
  WP = 0;

  while (1)
  {
/*    if(!EEStartWrite(0x0040))
    {
      Buffer[0] = 0;
      EEWritePage(Buffer);
    }
    
    EEStop();
    
    timer = 0;
    while(timer < 10);
    
    if(!EEStartWrite(0x0040))
    {
      Buffer[0] = 1;
      EEWritePage(Buffer);
    }
    
    EEStop();
    
    timer = 0;
    while(timer < 10);
*/    
    if(!EEStartWrite(0x0000))
    {
      if(!EEStartRead())
      {
        EEReadPage(RxBuf);
      }
    }
    
    EEStop();
    
    timer = 0;
    while(timer < 10);
    
    if(!EEStartWrite(0x0040))
    {
      if(!EEStartRead())
      {
        EEReadPage(RxBuf);
      }
    }
    
    EEStop();
  }                              
}

char EEStartRead(void)
{
  char Ack;
  
  SDA = 1;
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SDA = 0;
  SDA = 0;
  SCL = 0;
  SDA = 1;        // A6 = 1
  EESclPulse();
    
  SDA = 0;        // A5 = 0
  EESclPulse();
    
  SDA = 1;        // A4 = 1
  EESclPulse();
    
  SDA = 0;        // A3 = 0
  EESclPulse();
    
  SDA = 0;        // A2 = 0
  EESclPulse();
    
  SDA = 0;        // A1 = 0
  EESclPulse();
    
  SDA = 0;        // A0 = 0
  EESclPulse();
    
  SDA = 1;        // R
  EESclPulse();
  
  SDA = 1;
  Ack = SDA;
  
  EESclPulse();
  
  return Ack;  
}

char EEStartWrite(unsigned int Addr)
{
  unsigned char n;
  
  char Ack;  
  unsigned char AH = Addr>>8;
  unsigned char AL = Addr&0x00ff;
  
  SDA = 1;
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SDA = 0;
  SDA = 0;
  SCL = 0;
  SDA = 1;        // A6 = 1
  EESclPulse();
    
  SDA = 0;        // A5 = 0
  EESclPulse();
    
  SDA = 1;        // A4 = 1
  EESclPulse();
    
  SDA = 0;        // A3 = 0
  EESclPulse();
    
  SDA = 0;        // A2 = 0
  EESclPulse();
    
  SDA = 0;        // A1 = 0
  EESclPulse();
    
  SDA = 0;        // A0 = 0
  EESclPulse();
    
  SDA = 0;        // W
  EESclPulse();
  
  SDA = 1;
  Ack = SDA;
  
  EESclPulse();
  
  if(Ack == 0)
  {
    for(n = 0; n < 8; n ++)
    {
      if(AH&0x80) SDA = 1;
      else SDA = 0;
      EESclPulse();
      AH <<= 1;
    }
    
    SDA = 1;
    Ack = SDA;
    EESclPulse();
  }
  
  if(Ack == 0)
  {
    for(n = 0; n < 8; n ++)
    {
      if(AL&0x80) SDA = 1;
      else SDA = 0;      
      EESclPulse();
      AL <<= 1;
    }
      
    SDA = 1;
    Ack = SDA;
    EESclPulse();  
  }
  
  return Ack; 
}

void EEStop(void)
{
  SDA = 0;
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SDA = 1;
  SDA = 1;
}

void EESclPulse(void)
{
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SCL = 1;
  SCL = 0;
  SCL = 0;
  SCL = 0;
  SCL = 0;
}

void EEWritePage(unsigned char xdata * pBuf)
{
  unsigned char x, y;
  unsigned char ch;
  
  for(x = 0; x < 64; x ++)
  {
    ch = pBuf[x];
    for(y = 0; y < 8; y ++)
    {
      if(ch&0x80) SDA = 1;
      else SDA = 0;          
      EESclPulse();
      ch <<= 1;
    }
    
    SDA = 1;
    EESclPulse();   
  }
}

void EEReadPage(unsigned char xdata * pBuf)
{
  unsigned char x, y, z;
  
  for(x = 0; x < 64; x ++)
  {
    SDA = 1;
    z = 0;
    for(y = 0; y < 8; y++)
    {
      z <<= 1;
      if(SDA != 0) z ++;
      EESclPulse();
    }
    pBuf[x] = z;
    if(x != 63) SDA = 0;
    else SDA = 1;
    EESclPulse();
    SDA = 1;
  }
}

void T0IntSer(void) interrupt 1
{
  unsigned char x;
  
  TH0=0xf7;
  
  XBYTE[0x8060] = 0x00;
  XBYTE[0x8061] = Dig[ScanPos];
  XBYTE[0x8060] = tab[dis[ScanPos]];
  x = XBYTE[0x8060];
  x <<= ScanPos*4;
  KEY &= ~(0x0f<<ScanPos*4);
  KEY |= x;
  ScanPos = (ScanPos+1)&0x01;
  
  timer++;
}
